#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['etils',
 'etils.array_types',
 'etils.eapp',
 'etils.ecolab',
 'etils.edc',
 'etils.enp',
 'etils.enp.array_types',
 'etils.epath',
 'etils.epy',
 'etils.etqdm',
 'etils.etree',
 'etils.lazy_imports']

package_data = \
{'': ['*'], 'etils.epath': ['docs/*']}

extras_require = \
{'all': ['etils[array-types]',
         'etils[eapp]',
         'etils[ecolab]',
         'etils[edc]',
         'etils[enp]',
         'etils[epath]',
         'etils[epy]',
         'etils[etqdm]',
         'etils[etree]',
         'etils[etree-dm]',
         'etils[etree-jax]',
         'etils[etree-tf]'],
 'array-types': ['etils[enp]'],
 'dev': ['pytest',
         'pytest-subtests',
         'pytest-xdist',
         'pylint>=2.6.0',
         'yapf',
         'chex'],
 'eapp': ['absl-py', 'simple_parsing'],
 'ecolab': ['jupyter', 'numpy', 'mediapy', 'etils[enp]', 'etils[epy]'],
 'edc': ['typing_extensions', 'etils[epy]'],
 'enp': ['numpy', 'etils[epy]'],
 'epath': ['importlib_resources', 'typing_extensions', 'zipp', 'etils[epy]'],
 'epy': ['typing_extensions'],
 'etqdm': ['absl-py', 'tqdm', 'etils[epy]'],
 'etree': ['etils[array_types]', 'etils[epy]', 'etils[enp]', 'etils[etqdm]'],
 'etree-dm': ['dm-tree', 'etils[etree]'],
 'etree-jax': ['jax[cpu]', 'etils[etree]'],
 'etree-tf': ['tf-nightly', 'etils[etree]'],
 'lazy-imports': ['etils[ecolab]']}

setup(name='etils',
      version='%%PORTVERSION%%',
      description='Collection of common python utils',
      author=None,
      author_email='Conchylicultor <etils@google.com>',
      url=None,
      packages=packages,
      package_data=package_data,
      extras_require=extras_require,
      python_requires='>=3.7',
     )
